<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('employee_id', 'employee_number', 'password', 'is_send_otp');
    protected $hidden = array('password');

    public function employee()
    {
        return $this->belongsTo('App\Modules\HR\Entities\Employee');
    }

}